/* =============== MAP OBJECT =============== */

// Set the options of the map object
var map = L.map('map',{
    minZoom: 4,
    maxZoom: 7,
    center: [50.0,7.5],
    zoom: 5,
    zoomControl: false
    });
             
/* =============== LAYERS OBJECTS =============== */  

// Define the base layer object and add it to the map
// see http://leaflet-extras.github.io/leaflet-providers/preview/index.html
var baseLayer = new L.tileLayer.provider('OpenStreetMap.BlackAndWhite').addTo(map);

//loading the geojson using a js file for the power plant - CLUSTER

// Style function for the power plants layer
function getColor(status) {
    if (status =='active'){return "#FF006F" }
    else if (status =='closed'){return "#20679A" }
    else if (status == "under construction"){return "#0FB248"}
    else {return "#FCFF15"}
}

// function for the popup window
function popUpNPP(feature,layer){
    layer.bindPopup('<b>' + feature.properties.Name + '</b></br><small>('+ feature.properties.Status + ' )</small>');
    layer.on('mouseover', function(e){
        this.openPopup();
    });
};

// Add the data
// icon for the single markers
 var cityIcon = L.icon({
        iconUrl: 'icon/flash.png',
        iconSize:    [20, 20],
        iconAnchor:  [0, 0] 
    });
// Define the cluster group
var markers = new L.MarkerClusterGroup({
    showCoverageOnHover: false,
    maxClusterRadius: 80
});

// Adding the attribution to a GEOJSON (not natively supported)
// see http://bl.ocks.org/tmcw/05c7d1164a9e62e67e6d
markers.getAttribution = function() { return 'Source: <a href="http://en.wikipedia.org/wiki/List_of_power_stations_in_Europe" target="_blank">Wikipedia</a>'; };
// link the geojson to the group
markers.addLayer(L.geoJson(eu_nuclear_plants,{
    onEachFeature: popUpNPP,
    pointToLayer: function(feature, latlng) {
        return L.marker(latlng,{icon:cityIcon})}
    }));
map.addLayer(markers);



/* =============== CONTROL OBJECTS =============== */

// Add the scale bar
// see http://leafletjs.com/reference.html#control-scale
L.control.scale().addTo(map);

// Add the layer control
// see http://leafletjs.com/reference.html#control-layers
var baseLayers = {
    "OSM Black/White": baseLayer
    };
var overlays = {
    "Nuclear Plants":markers
    };
L.control.layers(baseLayers, overlays, {
    position: 'topright',
    collapsed:true,
    autoZIndex: true
    }).addTo(map);

map.addControl(new L.Control.Zoomslider());

// Coordinates plugin
L.control.coordinates({position:"bottomleft", //optional default "bootomright"
    decimals:3, //optional default 4
    decimalSeperator:".", //optional default "."
    labelTemplateLat:"Latitude: {y}", //optional default "Lat: {y}"
    labelTemplateLng:"Longitude: {x}", //optional default "Lng: {x}"
    enableUserInput:false, //optional default true
    useDMS:true, //optional default false
    useLatLngOrder: true //ordering of labels, default false-> lng-lat
    }).addTo(map);


 
