/* =============== MAP OBJECT =============== */

// Set the options of the map object
var map = L.map('map',{
    minZoom: 4,
    maxZoom: 7,
    center: [50.0,7.5],
    zoom: 5
    });
             
/* =============== LAYERS OBJECTS =============== */  

// Define the base layer object and add it to the map
// see http://leaflet-extras.github.io/leaflet-providers/preview/index.html
var baseLayer = new L.tileLayer.provider('OpenStreetMap.BlackAndWhite').addTo(map);
var baseLayer2 = new L.tileLayer.provider('OpenStreetMap.Mapnik');

// Specific functions for the choropleth
// Define the different classes and the appropriate colors
function getColor(percentage){
    if (percentage >0 && percentage <=10){return "#ffffcc"}
    else if (percentage >10 && percentage <=20){return "#c2e699"}
    else if (percentage >20 && percentage <=30){return "#78c679"}
    else if (percentage >30){return "#238443"}
    else {return '#ffffff'}
}
// Define the style of the polygons
function style(feature){
    return {
        fillColor: getColor(feature.properties.PERC_RENEW),
        color: '#ffffff',
        weight: 1,
        opacity: 1,
        fillOpacity: 0.8
    };
}

// Define the info element with a custom Control object
var info = L.control({position:'bottomright'});
// Add a div element to the DOM of the html document
info.onAdd = function (map) {
    this._div = L.DomUtil.create('div', 'info'); // create a div with a class "info"
    this.update();
    return this._div;
};
// method that we will use to update the control based on feature properties passed
info.update = function (props) {
    this._div.innerHTML = '<h4>Renewable Energy</h4>' +  (props ?
        '<b>' + props.CTRY_NAME + '</b><br />' + props.PERC_RENEW + ' %'
        : 'Hover over a country<br />    %');
};

// Define the legend element with a custom Control object
var legend = L.control({position: 'bottomright'});
legend.onAdd = function (map) {
    var div = L.DomUtil.create('div', 'info legend'),
        grades = [0, 10, 20, 30],
        labels = [];
    // loop through our percentage intervals and generate a label with a colored square for each interval
    for (var i = 0; i < grades.length; i++) {
        div.innerHTML +=
            '<i style="background-color:' + getColor(grades[i] + 1) + '"></i> ' +
            grades[i] + (grades[i + 1] ? '&ndash;' + grades[i + 1] + '<br>' : '+');
    }
    return div;
};

// Add the legend and the info elements to the map
legend.addTo(map);
info.addTo(map);

// Highlight functions: event listeners for setting and resetting the style
function highlightFeature(e) {
    var layer = e.target;
    layer.setStyle({
        weight: 5,
        color: '#DD6565',
        dashArray: '',
        fillOpacity: 0.6
    });
    if (!L.Browser.ie && !L.Browser.opera) {
        layer.bringToFront();
    }
        info.update(layer.feature.properties); // added afterwards
}
function resetHighlight(e) {
    eu_countries_them.resetStyle(e.target);
    info.update();// added afterwards
}

// Zoom in: event listener for click
function zoomToFeature(e) {
    map.fitBounds(e.target.getBounds());
}

// Using the onEachFeature option to add the listeners to our layer
function onEachFeature(feature, layer) {
    layer.on({
        mouseover: highlightFeature,
        mouseout: resetHighlight,
        click: zoomToFeature
    });
}

// Add the layer with the style and the onEachFeature functions
var eu_countries_them = L.geoJson(eu_countries_them, {
    style:style,
    onEachFeature:onEachFeature});

/*// Adding the attribution to a GEOJSON (not natively supported)
// see http://bl.ocks.org/tmcw/05c7d1164a9e62e67e6d
eu_countries_them.getAttribution = function() { return 'Geometries: CIA World DataBank II; Statistics: Eurostat'; };*/

// Add the layer to the map
eu_countries_them.addTo(map);


//Custom icon for the cities
//see http://leafletjs.com/reference.html#icon
 var cityIcon = L.icon({
        iconUrl: 'icon/poles.png',
        iconSize:    [20, 20],
        iconAnchor:  [0, 0] 
    });

//see http://leafletjs.com/reference.html#geojson &  http://leafletjs.com/reference.html#marker
//pop up function going with it
function popUpCities(feature,layer){
    layer.bindPopup('<b>' + feature.properties.sort_name+'</b> (' + feature.properties.ctry_code +')');
    layer.on('mouseover', function(e){
        this.openPopup();
    });
};
// Add the data
var eu_cities = L.geoJson(eu_cities,{
    onEachFeature: popUpCities,
    pointToLayer: function(feature, latlng) {
        return L.marker(latlng,{icon:cityIcon});
    }});


/* =============== CONTROL OBJECTS =============== */

// Add the scale bar
// see http://leafletjs.com/reference.html#control-scale
L.control.scale().addTo(map);

// Add the layer control
// see http://leafletjs.com/reference.html#control-layers
var baseLayers = {
    "Base BW": baseLayer,
    "Base Color": baseLayer2
    };
var overlays = {
    "Countries": eu_countries_them,
    "Cities": eu_cities
    };
L.control.layers(baseLayers, overlays, {
    position: 'topright',
    collapsed:false,
    autoZIndex: true
    }).addTo(map);

