/* =============== MAP OBJECT =============== */

// Set the options of the map object
var map = L.map('map',{
    minZoom: 4,
    maxZoom: 7,
    center: [50.0,7.5],
    zoom: 5
    });
             
/* =============== LAYERS OBJECTS =============== */  

// Define the base layer object and add it to the map
// see http://leaflet-extras.github.io/leaflet-providers/preview/index.html

var baseLayer = new L.tileLayer.provider('OpenStreetMap.Mapnik').addTo(map);


var eu_countries_them = L.tileLayer.wms("http://localhost/cgi-bin/qgis_map_server/qgis_map_serv.cgi?", {
    layers: 'eu_countries_them',
	styles:'choro',
    format: 'image/png',
    transparent: true,
    attribution: "Statistics © Eurostat"
});

var eu_countries_diagram = L.tileLayer.wms("http://localhost/cgi-bin/qgis_map_server/qgis_map_serv.cgi?", {
    layers: 'eu_countries_them',
	styles:'diagrams',
    format: 'image/png',
    transparent: true,
    attribution: "Statistics © Eurostat"
});



/* =============== CONTROL OBJECTS =============== */

// Add the scale bar
// see http://leafletjs.com/reference.html#control-scale
L.control.scale().addTo(map);

// Layer control
// see http://leafletjs.com/reference.html#control-layers
var baseLayers = {
    'OpenStreetMap': baseLayer
};

var overlays = {
	'Countries':eu_countries_them,
	'Diagrams': eu_countries_diagram
};

L.control.layers(baseLayers, overlays).addTo(map)

 
